/*
 * Copyright 2019 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*==================================================================================================
 Include Files
==================================================================================================*/
#include "lcl_utils.h"
#include "genfsk_interface.h"
/*==================================================================================================
 Private macros
==================================================================================================*/


/*==================================================================================================
 Private global variables declarations
==================================================================================================*/


/*==================================================================================================
 Private functions
==================================================================================================*/

#ifdef ENABLE_PROFILING
unsigned long oveflowTickCounter = 0;
void SysTick_Handler(void)
{
    oveflowTickCounter++;
    //LCL_ASSERT(oveflowTickCounter<=255);
}
#endif

/*==================================================================================================
 Public functions
==================================================================================================*/

/*!
 * @brief Performs manual lock of the AGC with the current index
 *
 * @return locked AGC index
 */
uint8_t LCL_lockAgc(uint8_t idx)
{  
#if 0 // why?
    /* limit AGC index to 24 */
    if(idx > 24U)
    {
        idx = 24U;
    }
#endif
    XCVR_SetManAgc(idx);
    
    return idx;
}

/*!
 * @brief Disable manual lock of the AGC (back to automatic mode)
 *
 * @return 
 */
void LCL_unlockAgc(void)
{
    /* make sure manual was set before trying to disable it, ignore otherwise */
    if( XCVR_RX_DIG->AGC_MAN_AGC_IDX & XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN_MASK)
    {
        XCVR_ClearManAgc();
    }
}

/*!
 * @brief Enable override of CFO_EST from the PHY
 *
 * @return 
 */
void LCL_enableCFOestimateOverride(uint32_t ovrd)
{
#if defined (RADIO_GEN_3P5)
    XCVR_RX_DIG->CFO_EST_OVRD = XCVR_RX_DIG_CFO_EST_OVRD_CFO_EST_OVRD(ovrd) | XCVR_RX_DIG_CFO_EST_OVRD_CFO_EST_OVRD_EN(1U);
#else
    (void) ovrd;
#endif /* RADIO_GEN_3P5 */
}

/*!
 * @brief Enable CFO_EST from the PHY
 *
 * @return 
 */
void LCL_disableCFOestimateOverride(void)
{
#if defined (RADIO_GEN_3P5)
    XCVR_RX_DIG->CFO_EST_OVRD = XCVR_RX_DIG_CFO_EST_OVRD_CFO_EST_OVRD(0) | XCVR_RX_DIG_CFO_EST_OVRD_CFO_EST_OVRD_EN(0U);
#endif /* RADIO_GEN_3P5 */
}
